'use strict';

function StudentRemoveModalCtrl($scope, $rootScope){
    $scope.group = {};
    $scope.student = {};

    $scope.$on('Groups:removeStudentModal', function(event, object){
        $scope.openModal();
        $scope.group = object.group;
        $scope.student = object.student;
    });


    $scope.openModal = function(){
        angular.element('#modal-student-remove').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-student-remove').modal('hide');
    }


    $scope.removeStudent = function(){
        $scope.student.destroy(function(){
            var index = $scope.group.users.indexOf($scope.student);
            $scope.group.users.splice(index, 1);
            $scope.closeModal();
        })
    }
}

StudentRemoveModalCtrl.$inject = ['$scope', '$rootScope'];